<?php

header('Content-Type: application/json');

$status = [
    'php_version' => phpversion(),
    'pdo_mysql_loaded' => extension_loaded('pdo_mysql'),
    'config_exists' => file_exists(__DIR__ . '/includes/config.php'),
    'db_connection' => false,
    'errors' => []
];

// Check DB Connection
if ($status['config_exists']) {
    require_once __DIR__ . '/includes/config.php';
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $status['db_connection'] = true;
    } catch (PDOException $e) {
        $status['errors'][] = "Database connection failed: " . $e->getMessage();
    }
} else {
    $status['errors'][] = "Config file missing.";
}

echo json_encode($status, JSON_PRETTY_PRINT);
