<?php

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function currentUser() {
    if (!isLoggedIn()) {
        return null;
    }
    // In a real app we might cache this or fetch from DB if needed
    // For now, let's assume session has enough info or fetch fresh
    // To be safe, let's fetch fresh from DB to ensure role is correct
    $userModel = new UserModel(getPDO());
    return $userModel->findById($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        redirect(base_url('login.php'));
    }
}

function loginUser($user) {
    session_regenerate_id(true);
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_name'] = $user['name'];
    $_SESSION['user_role'] = $user['role'];
    $_SESSION['last_login'] = time();
}

function logoutUser() {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}

function isAdmin() {
    if (!isLoggedIn()) {
        return false;
    }

    $userModel = new UserModel(getPDO());
    $user = $userModel->findById($_SESSION['user_id']);
    if (!$user) {
        return false;
    }

    // Keep session role in sync with database
    $_SESSION['user_role'] = $user['role'];
    return $user['role'] === 'admin';
}

function requireAdmin() {
    requireLogin();
    if (!isAdmin()) {
        logoutUser();
        die("Access Denied: Admins only.");
    }
}
