<?php

session_start();

// Load Config
$configFile = __DIR__ . '/config.php';
if (file_exists($configFile)) {
    require_once $configFile;
} else {
    // Fallback or error if config is missing
    die("Configuration file (config.php) is missing. Please copy includes/config.example.php to includes/config.php.");
}

// Load Core Includes
require_once __DIR__ . '/database.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/subscription.php';

// Load Helper Functions
require_once __DIR__ . '/helpers/settings.php';
require_once __DIR__ . '/helpers/uploads.php';

// Load site settings into global variable
$siteSettings = loadSiteSettings();

// Autoload Models (Simple manual require for now or basic autoloader)
// Let's just manually require the ones we know for simplicity as requested
require_once __DIR__ . '/models/UserModel.php';
require_once __DIR__ . '/models/ArticleModel.php';
require_once __DIR__ . '/models/QuoteModel.php';
require_once __DIR__ . '/models/StatsModel.php';
require_once __DIR__ . '/models/ChallengeModel.php';
require_once __DIR__ . '/models/MoodModel.php';
require_once __DIR__ . '/models/LearningPathModel.php';

// Load Controllers
require_once __DIR__ . '/controllers/AuthController.php';
require_once __DIR__ . '/controllers/ArticleController.php';
require_once __DIR__ . '/controllers/QuoteController.php';
require_once __DIR__ . '/controllers/DashboardController.php';
require_once __DIR__ . '/controllers/LearningPathController.php';
require_once __DIR__ . '/controllers/SettingsController.php';
require_once __DIR__ . '/controllers/MagazineController.php';
require_once __DIR__ . '/controllers/NewsletterController.php';
require_once __DIR__ . '/controllers/SubscriptionController.php';
require_once __DIR__ . '/controllers/EyeExerciseController.php';
require_once __DIR__ . '/controllers/EyeRoutineController.php';
