<?php

// Database Configuration (env overrides keep deployments safer)
define('DB_HOST', getenv('DB_HOST') ?: 'db.snooxednfhtyzqhnywog.supabase.co');
define('DB_PORT', getenv('DB_PORT') ?: '5432');
define('DB_NAME', getenv('DB_NAME') ?: 'postgres');
define('DB_USER', getenv('DB_USER') ?: 'postgres');
define('DB_PASS', getenv('DB_PASS') ?: 'PLACEHOLDER_PASSWORD'); // User needs to replace this
define('DB_CHARSET', getenv('DB_CHARSET') ?: 'utf8mb4');
define('DB_DSN', getenv('DB_DSN') ?: ''); // Optional: full DSN (e.g., sqlite::memory: for tests)
define('DB_DRIVER', getenv('DB_DRIVER') ?: 'mysql'); // mysql or pgsql (or others when using DB_DSN)

// App Configuration
define('BASE_URL', getenv('BASE_URL') ?: 'http://localhost:8000');
define('APP_ENV', getenv('APP_ENV') ?: 'local'); // 'local' or 'production'

// Supabase (used for external tests; keep secrets in env variables)
define('SUPABASE_URL', rtrim(getenv('SUPABASE_URL') ?: '', '/'));
define('SUPABASE_ANON_KEY', getenv('SUPABASE_ANON_KEY') ?: '');
define('SUPABASE_SERVICE_ROLE_KEY', getenv('SUPABASE_SERVICE_ROLE_KEY') ?: '');
define('SUPABASE_ACCESS_TOKEN', getenv('SUPABASE_ACCESS_TOKEN') ?: ''); // Personal access token for the management API

// Error Reporting
if (APP_ENV === 'local') {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(E_ALL);
}
