<?php

class DashboardController {
    protected $pdo;
    protected $userModel;
    protected $statsModel;
    protected $articleModel;

    protected $challengeModel;
    protected $moodModel;

    public function __construct($pdo) {
        $this->pdo = $pdo;
        $this->userModel = new UserModel($pdo);
        $this->statsModel = new StatsModel($pdo);
        $this->articleModel = new ArticleModel($pdo);
        $this->challengeModel = new ChallengeModel($pdo);
        $this->moodModel = new MoodModel($pdo);
    }

    public function index() {
        $user = currentUser();
        if (!$user) {
            redirect(base_url('login.php'));
        }

        $stats = $this->statsModel->getUserStats($user['id']);
        $recentArticles = $this->articleModel->getPublishedArticles(3);
        $dailyChallenge = $this->challengeModel->getDailyChallenge($user['id']);
        $todayMood = $this->moodModel->getTodayMood($user['id']);

        return [
            'user' => $user,
            'stats' => $stats,
            'recentArticles' => $recentArticles,
            'dailyChallenge' => $dailyChallenge,
            'todayMood' => $todayMood
        ];
    }
}
