<?php

function getPDO() {
    static $pdo = null;

    if ($pdo === null) {
        try {
            if (!empty(DB_DSN)) {
                $dsn = DB_DSN;
            } else {
                $driver = DB_DRIVER ?: 'mysql';
                if ($driver === 'pgsql') {
                    $dsn = "pgsql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME;
                } else {
                    $dsn = $driver . ":host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
                }
            }

            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
            ];
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (\PDOException $e) {
            if (APP_ENV === 'local') {
                throw new \PDOException($e->getMessage(), (int)$e->getCode());
            } else {
                die("Database connection failed.");
            }
        }
    }

    return $pdo;
}
