<?php

class ArticleModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getPublishedArticles($limit = 10, $offset = 0) {
        $stmt = $this->pdo->prepare("SELECT * FROM articles WHERE published = 1 ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getArticleBySlug($slug) {
        $stmt = $this->pdo->prepare("SELECT * FROM articles WHERE slug = :slug AND published = 1 LIMIT 1");
        $stmt->execute(['slug' => $slug]);
        return $stmt->fetch();
    }

    public function getAllArticles() {
        $stmt = $this->pdo->query("SELECT * FROM articles ORDER BY created_at DESC");
        return $stmt->fetchAll();
    }

    public function createArticle($title, $slug, $body, $excerpt, $category, $published) {
        $stmt = $this->pdo->prepare("INSERT INTO articles (title, slug, body, excerpt, category, published, created_at) VALUES (:title, :slug, :body, :excerpt, :category, :published, CURRENT_TIMESTAMP)");
        return $stmt->execute([
            'title' => $title,
            'slug' => $slug,
            'body' => $body,
            'excerpt' => $excerpt,
            'category' => $category,
            'published' => $published
        ]);
    }

    public function updateArticle($id, $title, $slug, $body, $excerpt, $category, $published) {
        $stmt = $this->pdo->prepare("UPDATE articles SET title = :title, slug = :slug, body = :body, excerpt = :excerpt, category = :category, published = :published WHERE id = :id");
        return $stmt->execute([
            'id' => $id,
            'title' => $title,
            'slug' => $slug,
            'body' => $body,
            'excerpt' => $excerpt,
            'category' => $category,
            'published' => $published
        ]);
    }

    public function deleteArticle($id) {
        $stmt = $this->pdo->prepare("DELETE FROM articles WHERE id = :id");
        return $stmt->execute(['id' => $id]);
    }
    
    public function getArticleById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM articles WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    }
}
