<?php

class MoodModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function logMood($userId, $value, $note) {
        $date = date('Y-m-d');
        $stmt = $this->pdo->prepare("
            INSERT INTO daily_mood (user_id, mood_value, note, date) 
            VALUES (:user_id, :value, :note, :date)
            ON DUPLICATE KEY UPDATE mood_value = :value, note = :note
        ");
        return $stmt->execute([
            'user_id' => $userId,
            'value' => $value,
            'note' => $note,
            'date' => $date
        ]);
    }

    public function getTodayMood($userId) {
        $date = date('Y-m-d');
        $stmt = $this->pdo->prepare("SELECT * FROM daily_mood WHERE user_id = :user_id AND date = :date LIMIT 1");
        $stmt->execute(['user_id' => $userId, 'date' => $date]);
        return $stmt->fetch();
    }

    public function getMoodHistory($userId, $days = 7) {
        $stmt = $this->pdo->prepare("
            SELECT * FROM daily_mood 
            WHERE user_id = :user_id 
            ORDER BY date DESC 
            LIMIT :days
        ");
        $stmt->bindValue(':user_id', $userId, PDO::PARAM_INT);
        $stmt->bindValue(':days', $days, PDO::PARAM_INT);
        $stmt->execute();
        return array_reverse($stmt->fetchAll());
    }
}
