<?php

class QuoteModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getRandomQuote() {
        $stmt = $this->pdo->query("SELECT * FROM quotes ORDER BY RAND() LIMIT 1");
        return $stmt->fetch();
    }

    public function getAllQuotes() {
        $stmt = $this->pdo->query("SELECT * FROM quotes ORDER BY created_at DESC");
        return $stmt->fetchAll();
    }

    public function createQuote($text, $author) {
        $stmt = $this->pdo->prepare("INSERT INTO quotes (text, author, created_at) VALUES (:text, :author, CURRENT_TIMESTAMP)");
        return $stmt->execute([
            'text' => $text,
            'author' => $author
        ]);
    }

    public function deleteQuote($id) {
        $stmt = $this->pdo->prepare("DELETE FROM quotes WHERE id = :id");
        return $stmt->execute(['id' => $id]);
    }
}
