<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$subscriptionController = new SubscriptionController(getPDO());
$pdo = getPDO();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $action = $_POST['action'] ?? '';
    
    if ($action === 'grant') {
        $userId = $_POST['user_id'] ?? null;
        $planId = $_POST['plan_id'] ?? null;
        $endDate = $_POST['end_date'] ?? null;
        
        if ($userId && $planId) {
            if ($subscriptionController->grantSubscription($userId, $planId, date('Y-m-d'), $endDate)) {
                flash('flash_message', 'Subscription granted successfully!', 'success');
            } else{
                flash('flash_message', 'Error granting subscription.', 'danger');
            }
        }
    } elseif ($action === 'revoke') {
        $subscriptionId = $_POST['subscription_id'] ?? null;
        if ($subscriptionController->revokeSubscription($subscriptionId)) {
            flash('flash_message', 'Subscription revoked successfully!', 'success');
        } else {
            flash('flash_message', 'Error revoking subscription.', 'danger');
        }
    }
    
    redirect(base_url('admin/subscriptions.php'));
}

// Get  data
$plans = $subscriptionController->getAllPlans(false);
$filter = $_GET['filter'] ?? 'active';
$filters = ['status' => $filter];
$userSubscriptions = $subscriptionController->getAllUserSubscriptions($filters);
$stats = $subscriptionController->getStatistics();

// Get all users for grant subscription dropdown
$stmt = $pdo->query("SELECT id, name, email FROM users ORDER BY name");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pageTitle = 'Subscriptions - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container { max-width: 1400px; margin: 40px auto; padding: 20px; }
        .admin-nav { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 30px; }
        .admin-nav a { margin-right: 15px; padding: 8px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin-bottom: 5px; }
        .admin-nav a:hover { background: #0056b3; }
        .admin-nav a.active { background: #28a745; }
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: #fff; border: 1px solid #ddd; border-radius: 8px; padding: 20px; text-align: center; }
        .stat-card h3 { margin: 0; font-size: 32px; color: #007bff; }
        .stat-card p { margin: 5px 0 0; color: #666; }
        .btn { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background: #0056b3; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f8f9fa; font-weight: bold; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        .alert-danger { background: #f8d7da; color: #721c24; }
        .badge { padding: 4px 8px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .badge-active { background: #28a745; color: white; }
        .badge-expired { background: #dc3545; color: white; }
        .filter-tabs { margin-bottom: 20px; }
        .filter-tabs a { padding: 10px 20px; background: #f8f9fa; border: 1px solid #ddd; text-decoration: none; color: #333; display: inline-block; margin-right: 5px; border-radius: 5px 5px 0 0; }
        .filter-tabs a.active { background: #007bff; color: white; border-color: #007bff; }
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; }
        .modal.active { display: flex; align-items: center; justify-content: center; }
        .modal-content { background: white; padding: 30px; border-radius: 10px; max-width: 500px; width: 90%; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; font-weight: bold; margin-bottom: 5px; }
        .form-group input, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; }
        .plans-section { background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 30px; }
        .plan-card { background: white; border: 1px solid #ddd; padding: 15px; border-radius: 8px; margin-bottom: 10px; display: flex; justify-content: space-between; align-items: center; }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - Subscriptions</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php flash('flash_message'); ?>
        
        <div class="stats-grid">
            <div class="stat-card">
                <h3><?= e($stats['active']) ?></h3>
                <p>Active Subscriptions</p>
            </div>
            <div class="stat-card">
                <h3><?= e($stats['expired']) ?></h3>
                <p>Expired</p>
            </div>
            <?php foreach ($stats['by_plan'] as $planStat): ?>
            <div class="stat-card">
                <h3><?= e($planStat['count']) ?></h3>
                <p><?= e($planStat['plan_name']) ?></p>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="plans-section">
            <h2>Subscription Plans</h2>
            <?php foreach ($plans as $plan): ?>
            <div class="plan-card">
                <div>
                    <strong><?= e($plan['plan_name']) ?></strong>
                    (<?= e($plan['plan_slug']) ?>)
                    - $<?= e($plan['price']) ?> / <?= e($plan['billing_cycle']) ?>
                    <?php if (!$plan['is_active']): ?>
                        <span class="badge badge-expired">Inactive</span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div style="margin-bottom: 20px;">
            <button class="btn" onclick="openModal()">+ Grant Subscription</button>
        </div>
        
        <div class="filter-tabs">
            <a href="?filter=active" class="<?= $filter === 'active' ? 'active' : '' ?>">Active</a>
            <a href="?filter=expired" class="<?= $filter === 'expired' ? 'active' : '' ?>">Expired</a>
        </div>
        
        <h2>User Subscriptions</h2>
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Email</th>
                    <th>Plan</th>
                    <th>Price</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($userSubscriptions)): ?>
                    <tr>
                        <td colspan="8" style="text-align: center; padding: 40px;">
                            No subscriptions found.
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($userSubscriptions as $sub): ?>
                    <?php 
                    $isActive = strtotime($sub['start_date']) <= time() && 
                                (empty($sub['end_date']) || strtotime($sub['end_date']) >= time());
                    ?>
                    <tr>
                        <td><?= e($sub['user_name']) ?></td>
                        <td><?= e($sub['user_email']) ?></td>
                        <td><?= e($sub['plan_name']) ?></td>
                        <td><?= e($sub['currency']) ?> <?= e($sub['price']) ?></td>
                        <td><?= e(date('Y-m-d', strtotime($sub['start_date']))) ?></td>
                        <td><?= $sub['end_date'] ? e(date('Y-m-d', strtotime($sub['end_date']))) : 'No expiry' ?></td>
                        <td>
                            <?php if ($isActive): ?>
                                <span class="badge badge-active">Active</span>
                            <?php else: ?>
                                <span class="badge badge-expired">Expired</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($isActive): ?>
                                <form method="POST" style="display:inline;" onsubmit="return confirm('Revoke this subscription?');">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="action" value="revoke">
                                    <input type="hidden" name="subscription_id" value="<?= e($sub['id']) ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">Revoke</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Grant Subscription Modal -->
    <div id="grantModal" class="modal">
        <div class="modal-content">
            <h2>Grant Subscription</h2>
            <form method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="action" value="grant">
                
                <div class="form-group">
                    <label for="user_id">User</label>
                    <select id="user_id" name="user_id" required>
                        <option value="">Select User</option>
                        <?php foreach ($users as $user): ?>
                            <option value="<?= e($user['id']) ?>"><?= e($user['name']) ?> (<?= e($user['email']) ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="plan_id">Plan</label>
                    <select id="plan_id" name="plan_id" required>
                        <option value="">Select Plan</option>
                        <?php foreach ($plans as $plan): ?>
                            <option value="<?= e($plan['id']) ?>"><?= e($plan['plan_name']) ?> ($<?= e($plan['price']) ?>/<?= e($plan['billing_cycle']) ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="end_date">End Date (optional - leave empty for no expiry)</label>
                    <input type="date" id="end_date" name="end_date">
                </div>
                
                <button type="submit" class="btn">Grant Subscription</button>
                <button type="button" class="btn btn-danger" onclick="closeModal()">Cancel</button>
            </form>
        </div>
    </div>
    
    <script>
        function openModal() {
            document.getElementById('grantModal').classList.add('active');
        }
        function closeModal() {
            document.getElementById('grantModal').classList.remove('active');
        }
    </script>
</body>
</html>
