<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$articleModel = new ArticleModel(getPDO());

if (isset($_GET['slug'])) {
    $slug = $_GET['slug'];
    $article = $articleModel->getArticleBySlug($slug);

    if (!$article) {
        http_response_code(404);
        die("Article not found");
    }

    include __DIR__ . '/../templates/layout/header.php';
    include __DIR__ . '/../templates/articles/detail.php';
    include __DIR__ . '/../templates/layout/footer.php';
} else {
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 10;
    $offset = ($page - 1) * $limit;
    
    $articles = $articleModel->getPublishedArticles($limit, $offset);
    
    include __DIR__ . '/../templates/layout/header.php';
    include __DIR__ . '/../templates/articles/list.php';
    include __DIR__ . '/../templates/layout/footer.php';
}
