<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Fetch latest articles
$articleModel = new ArticleModel(getPDO());
$latestArticles = $articleModel->getPublishedArticles(3);

include __DIR__ . '/../templates/layout/header.php';
?>

<div class="hero text-center mb-4" style="padding: 4rem 1rem; background: var(--card-bg); border-radius: var(--radius); box-shadow: var(--shadow);">
    <h1 style="font-size: 3rem; margin-bottom: 1rem; color: var(--primary-color);">Welcome to Enterlife</h1>
    <p class="lead" style="font-size: 1.25rem; color: var(--text-muted); max-width: 600px; margin: 0 auto 2rem;">Your personal space for focus, breathing, and growth. Disconnect to reconnect.</p>
    <div class="cta-buttons" style="display: flex; gap: 1rem; justify-content: center;">
        <?php if (!isLoggedIn()): ?>
            <a href="register.php" class="btn btn-primary btn-lg">Get Started</a>
            <a href="login.php" class="btn btn-secondary btn-lg">Login</a>
        <?php else: ?>
            <a href="dashboard.php" class="btn btn-primary btn-lg">Go to Dashboard</a>
        <?php endif; ?>
    </div>
</div>

<div class="features grid grid-cols-3 mb-4">
    <div class="card text-center">
        <div style="font-size: 2rem; margin-bottom: 1rem;">🧘</div>
        <h3>Mindfulness</h3>
        <p>Guided breathing and meditation tools to help you stay grounded.</p>
    </div>
    <div class="card text-center">
        <div style="font-size: 2rem; margin-bottom: 1rem;">⏱️</div>
        <h3>Focus</h3>
        <p>Pomodoro timer and focus tracking to boost your productivity.</p>
    </div>
    <div class="card text-center">
        <div style="font-size: 2rem; margin-bottom: 1rem;">👁️</div>
        <h3>Wellness</h3>
        <p>Eye exercises and health tips to combat screen fatigue.</p>
    </div>
</div>

<div class="mb-4">
    <h2 class="text-center mb-4">Latest Insights</h2>
    <div class="grid grid-cols-3">
        <?php foreach ($latestArticles as $article): ?>
            <div class="card">
                <h3><a href="articles.php?slug=<?= e($article['slug']) ?>"><?= e($article['title']) ?></a></h3>
                <p class="text-muted" style="font-size: 0.9rem;"><?= date('F j, Y', strtotime($article['created_at'])) ?></p>
                <p><?= e($article['excerpt']) ?></p>
                <a href="articles.php?slug=<?= e($article['slug']) ?>" class="btn btn-sm btn-secondary mt-2">Read Article</a>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?php include __DIR__ . '/../templates/layout/footer.php'; ?>
