<?php
require_once __DIR__ . '/../includes/bootstrap.php';

requireLogin();

$magazineId = $_GET['id'] ?? null;

if (!$magazineId) {
    die('Magazine ID not specified');
}

$magazineController = new MagazineController(getPDO());
$magazine = $magazineController->getMagazineById($magazineId);

if (!$magazine) {
    die('Magazine not found');
}

// Check if magazine is public
if (!$magazine['is_public']) {
    die('This magazine is not available for download');
}

// Check if user has access
$userId = $_SESSION['user_id'];

if (isProOnly($magazine)) {
    if (!isPro($userId)) {
        // Redirect to upgrade page
        flash('flash_message', 'This magazine requires a PRO subscription. Please upgrade your account.', 'danger');
        redirect(base_url('upgrade.php?from=magazine&id=' . $magazineId));
    }
}

// Check if file exists
$filePath = __DIR__ . '/../' . ltrim($magazine['pdf_file_path'], '/');

if (!file_exists($filePath)) {
    die('Magazine file not found on server');
}

// Increment download count
$magazineController->incrementDownloadCount($magazineId);

// Serve the file
$filename = sanitizeFilename($magazine['title'] . '.pdf');
serveFile($filePath, $filename, true);
