<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$magazineController = new MagazineController(getPDO());

// Get filters
$categoryId = $_GET['category'] ?? null;
$filter = $_GET['filter'] ?? 'all';

$filters = ['is_public' => 1]; // Only show public magazines

if ($categoryId) {
    $filters['category_id'] = $categoryId;
}

if ($filter === 'free') {
    $filters['is_pro_only'] = 0;
} elseif ($filter === 'pro') {
    $filters['is_pro_only'] = 1;
}

$magazines = $magazineController->getAllMagazines($filters);
$categories = $magazineController->getAllCategories();

// Check if user is logged in and pro
$userId = $_SESSION['user_id'] ?? null;
$userIsPro = $userId ? isPro($userId) : false;

$pageTitle = 'Magazines | ' . getSetting('site_name', 'Enterlife');
$pageDescription = 'Browse our collection of health, wellness, and eye care magazines.';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <meta name="description" content="<?= e($pageDescription) ?>">
    
    <?php renderHeadScripts(); ?>
    
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 20px;
            text-align: center;
        }
        .page-header h1 {
            margin: 0 0 10px;
            font-size: 42px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        .filters {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            align-items: center;
        }
        .filters select, .filters a {
            padding: 10px 15px;
            border-radius: 5px;
            border: 1px solid #ddd;
            background: white;
            text-decoration: none;
            color: #333;
        }
        .filters a.active {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        .magazines-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 30px;
        }
        .magazine-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
            transition: transform 0.3s;
        }
        .magazine-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .magazine-cover {
            width: 100%;
            height: 350px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 48px;
            font-weight: bold;
        }
        .magazine-cover img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .magazine-info {
            padding: 20px;
        }
        .magazine-info h3 {
            margin: 0 0 10px;
            font-size: 20px;
        }
        .magazine-meta {
            font-size: 13px;
            color: #666;
            margin-bottom: 15px;
        }
        .magazine-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 10px;
        }
        .badge-pro {
            background: #ffd700;
            color: #333;
        }
        .badge-free {
            background: #28a745;
            color: white;
        }
        .download-btn {
            display: block;
            width: 100%;
            padding: 12px;
            background: #667eea;
            color: white;
            text-align: center;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            transition: background 0.3s;
        }
        .download-btn:hover {
            background: #5568d3;
        }
        .download-btn.locked {
            background: #6c757d;
        }
        .download-btn.locked:hover {
            background: #5a6268;
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
    </style>
</head>
<body>
    <?php renderBodyScripts(); ?>
    
    <div class="page-header">
        <h1>📚 Magazines</h1>
        <p>Browse our collection of wellness and eye care magazines</p>
    </div>
    
    <div class="container">
        <div class="filters">
            <span><strong>Filter:</strong></span>
            <a href="?filter=all" class="<?= $filter === 'all' ? 'active' : '' ?>">All Magazines</a>
            <a href="?filter=free" class="<?= $filter === 'free' ? 'active' : '' ?>">Free</a>
            <a href="?filter=pro" class="<?= $filter === 'pro' ? 'active' : '' ?>">PRO Only</a>
            
            <span style="margin-left: auto;"><strong>Category:</strong></span>
            <select onchange="window.location.href='?filter=<?= e($filter) ?>&category=' + this.value">
                <option value="">All Categories</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= e($cat['id']) ?>" <?= $categoryId == $cat['id'] ? 'selected' : '' ?>>
                        <?= e($cat['category_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <?php if (empty($magazines)): ?>
            <div class="empty-state">
                <h2>No magazines found</h2>
                <p>Check back later for new releases!</p>
            </div>
        <?php else: ?>
            <div class="magazines-grid">
                <?php foreach ($magazines as $mag): ?>
                <div class="magazine-card">
                    <div class="magazine-cover">
                        <?php if (!empty($mag['cover_image_path'])): ?>
                            <img src="<?= base_url($mag['cover_image_path']) ?>" alt="<?= e($mag['title']) ?>">
                        <?php else: ?>
                            📖
                        <?php endif; ?>
                    </div>
                    <div class="magazine-info">
                        <?php if ($mag['is_pro_only']): ?>
                            <span class="magazine-badge badge-pro">PRO</span>
                        <?php else: ?>
                            <span class="magazine-badge badge-free">Free</span>
                        <?php endif; ?>
                        
                        <h3><?= e($mag['title']) ?></h3>
                        
                        <div class="magazine-meta">
                            <?php if ($mag['issue_number']): ?>
                                Issue <?= e($mag['issue_number']) ?> •
                            <?php endif; ?>
                            <?= e($mag['year']) ?>
                            <?php if ($mag['month']): ?>
                                • <?= date('F', mktime(0, 0, 0, $mag['month'], 1)) ?>
                            <?php endif; ?>
                            <br>
                            <?= e($mag['download_count'] ?? 0) ?> downloads
                        </div>
                        
                        <?php if (!empty($mag['description'])): ?>
                            <p style="font-size: 14px; color: #666; margin-bottom: 15px;">
                                <?= e(substr($mag['description'], 0, 100)) ?><?= strlen($mag['description']) > 100 ? '...' : '' ?>
                            </p>
                        <?php endif; ?>
                        
                        <?php if ($mag['is_pro_only'] && !$userIsPro): ?>
                            <a href="<?= base_url('upgrade.php') ?>" class="download-btn locked">
                                🔒 Upgrade to PRO to Download
                            </a>
                        <?php else: ?>
                            <a href="<?= base_url('magazine-download.php?id=' . $mag['id']) ?>" class="download-btn">
                                📥 Download PDF
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <div style="text-align: center; padding: 40px 20px;">
        <p><a href="<?= base_url('dashboard.php') ?>">← Back to Dashboard</a></p>
    </div>
</body>
</html>
