<?php
require_once __DIR__ . '/../includes/bootstrap.php';

requireLogin();

$moodModel = new MoodModel(getPDO());
$user = currentUser();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    $value = $_POST['mood_value'];
    $note = $_POST['note'] ?? '';
    
    $moodModel->logMood($user['id'], $value, $note);
    flash('success', 'Mood logged.');
    redirect('mood.php');
}

$todayMood = $moodModel->getTodayMood($user['id']);
$history = $moodModel->getMoodHistory($user['id']);

include __DIR__ . '/../templates/layout/header.php';
include __DIR__ . '/../templates/mood/mood_form.php';
include __DIR__ . '/../templates/layout/footer.php';
