<?php
require_once __DIR__ . '/../includes/bootstrap.php';

if (isLoggedIn()) {
    redirect(base_url('dashboard.php'));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Basic validation
    if (empty($name) || empty($email) || empty($password)) {
        flash('error', 'All fields are required.');
        redirect(base_url('register.php'));
    }
    
    $userModel = new UserModel(getPDO());
    
    if ($userModel->findByEmail($email)) {
        flash('error', 'Email already registered.');
        redirect(base_url('register.php'));
    }
    
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);
    $userId = $userModel->createUser($email, $passwordHash, $name);
    
    if ($userId) {
        $user = $userModel->findById($userId);
        loginUser($user);
        flash('success', 'Welcome to Enterlife!');
        redirect(base_url('dashboard.php'));
    } else {
        flash('error', 'Registration failed. Please try again.');
    }
}

include __DIR__ . '/../templates/layout/header.php';
include __DIR__ . '/../templates/auth/register_form.php';
include __DIR__ . '/../templates/layout/footer.php';
