<h2>Articles</h2>

<?php if (empty($articles)): ?>
    <p>No articles found.</p>
<?php else: ?>
    <div class="article-list">
        <?php foreach ($articles as $article): ?>
            <div class="article-preview">
                <h3><a href="articles.php?slug=<?= e($article['slug']) ?>"><?= e($article['title']) ?></a></h3>
                <p class="meta">Published on <?= date('F j, Y', strtotime($article['created_at'])) ?></p>
                <p><?= e($article['excerpt']) ?></p>
                <a href="articles.php?slug=<?= e($article['slug']) ?>" class="read-more">Read more</a>
            </div>
            <hr>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
