<h2>Mood Tracker</h2>
<p class="lead">How are you feeling today?</p>

<div class="grid grid-cols-2">
    <div class="card">
        <h3>Log Today's Mood</h3>
        <?php if ($todayMood): ?>
            <div class="alert alert-success">
                You logged your mood as <strong><?= $todayMood['mood_value'] ?>/5</strong> today.
                <br>
                <em>"<?= e($todayMood['note']) ?>"</em>
            </div>
            <p>Want to update it?</p>
        <?php endif; ?>

        <form method="POST">
            <?= csrf_field() ?>
            <div class="form-group">
                <label>Mood (1 = Bad, 5 = Great)</label>
                <div style="display: flex; justify-content: space-between; font-size: 2rem; cursor: pointer;">
                    <?php for($i=1; $i<=5; $i++): ?>
                        <label>
                            <input type="radio" name="mood_value" value="<?= $i ?>" required <?= ($todayMood && $todayMood['mood_value'] == $i) ? 'checked' : '' ?>>
                            <?= $i ?>
                        </label>
                    <?php endfor; ?>
                </div>
            </div>
            <div class="form-group">
                <label>Note (Optional)</label>
                <textarea name="note" class="form-control" rows="3"><?= e($todayMood['note'] ?? '') ?></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Save Mood</button>
        </form>
    </div>

    <div class="card">
        <h3>Last 7 Days</h3>
        <?php if (empty($history)): ?>
            <p>No mood history yet.</p>
        <?php else: ?>
            <div style="display: flex; align-items: flex-end; height: 200px; gap: 10px; padding-top: 20px;">
                <?php foreach ($history as $entry): ?>
                    <div style="flex: 1; background-color: var(--primary-color); height: <?= ($entry['mood_value'] / 5) * 100 ?>%; border-radius: 4px 4px 0 0; position: relative;" title="<?= $entry['date'] ?>: <?= $entry['mood_value'] ?>">
                        <span style="
                            position: absolute; 
                            bottom: -25px; 
                            left: 50%; 
                            transform: translateX(-50%); 
                            font-size: 0.8rem;
                        "><?= date('D', strtotime($entry['date'])) ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
