<h2>Eye Exercises</h2>
<p>Follow the instructions to relax your eyes.</p>

<div class="card text-center mb-4">
    <h3 id="exercise-step" class="mt-4">Ready?</h3>
    <div id="timer" class="mt-2" style="font-size: 1.5rem; font-weight: bold;">00:00</div>
    <div class="mt-4">
        <button id="start-btn" class="btn btn-primary" onclick="startEyeExercises()">Start Session</button>
    </div>
</div>

<script>
function startEyeExercises() {
    const steps = [
        "Look Up", "Look Down", "Look Left", "Look Right", 
        "Roll Eyes Clockwise", "Roll Eyes Counter-Clockwise", "Blink Rapidly", "Close Eyes and Relax"
    ];
    let currentStep = 0;
    const container = document.getElementById('exercise-step');
    const btn = document.getElementById('start-btn');
    const timerDisplay = document.getElementById('timer');
    
    btn.style.display = 'none';
    
    // Estimate session length: steps * 3 seconds
    const sessionMinutes = Math.ceil((steps.length * 3) / 60);
    
    function nextStep() {
        if (currentStep >= steps.length) {
            container.innerText = "Done! Great job.";
            btn.style.display = 'inline-block';
            btn.innerText = "Restart";
            logSession(sessionMinutes);
            return;
        }
        
        container.innerText = steps[currentStep];
        currentStep++;
        setTimeout(nextStep, 3000); // 3 seconds per step
    }
    
    nextStep();
}

function logSession(minutes) {
    fetch('<?= base_url('api/tools/eye.php') ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ minutes: minutes })
    }).then(res => res.json())
      .then(data => console.log('Session logged:', data))
      .catch(err => console.error('Error logging session:', err));
}
</script>
