<?php

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/supabase.php';

$client = new SupabaseClient();

function showStatus(string $label, array $result): void
{
    $ok = $result['ok'] ? 'OK' : 'FAIL';
    $status = $result['status'] ?? '-';

    $summary = '';
    if ($result['ok'] && isset($result['body'])) {
        if (is_array($result['body'])) {
            $summary = json_encode($result['body']);
        } elseif (is_string($result['body'])) {
            $summary = $result['body'];
        }
    } elseif (!empty($result['error'])) {
        $summary = (string) $result['error'];
    }

    echo sprintf(
        "%s [%s] (HTTP %s)%s%s\n",
        $label,
        $ok,
        $status,
        $summary ? ': ' : '',
        $summary
    );
}

echo "Supabase test runner\n";
echo "--------------------\n";
echo "PAT provided: " . ($client->hasAccessToken() ? 'yes' : 'no') . "\n";
echo "Project config: " . ($client->hasProjectConfig() ? 'yes' : 'no') . "\n\n";

if ($client->hasAccessToken()) {
    $mgmt = $client->listProjects();
    // Only expose the count to avoid leaking project details
    if ($mgmt['ok'] && is_array($mgmt['body'])) {
        $mgmt['body'] = ['projects_found' => count($mgmt['body'])];
    }
    showStatus('Management API (projects list)', $mgmt);
} else {
    echo "Set SUPABASE_ACCESS_TOKEN to your personal access token to hit the management API.\n";
}

if ($client->hasProjectConfig()) {
    $health = $client->projectHealth();
    showStatus('Project auth health', $health);
} else {
    echo "Set SUPABASE_URL and SUPABASE_SERVICE_ROLE_KEY (or SUPABASE_ANON_KEY) to ping your project.\n";
}

echo "\nDone.\n";
